% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.feature.R
\name{extractor.feature}
\alias{extractor.feature}
\title{Extracting features for the pre-trained Long Short Term Memory (LSTM) Network}
\usage{
extractor.feature(
  response,
  cor.type = "pearson",
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{response}{A required \code{N} × \code{I} matrix or data.frame consisting of the responses of \code{N} individuals
to \code{I} items.}

\item{cor.type}{A character string indicating which correlation coefficient (or covariance) is to be computed. One of "pearson" (default),
"kendall", or "spearman". @seealso \link[stats]{cor}.}

\item{use}{An optional character string giving a method for computing covariances in the presence of missing values. This
must be one of the strings "everything", "all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs" (default).
@seealso \link[stats]{cor}.}
}
\value{
A matrix (1×20) containing all the features for the LSTM.
}
\description{
This function is used to extract the features required by the pre-trained
Long Short Term Memory (LSTM) Network.  @seealso \link[LSTMfactors]{LSTM}
}
\details{
For \code{"LSTM"}, a total of 2 types of features. These features are as follows:
\describe{
  \item{(1)}{The top 10 largest eigenvalues.}
  \item{(2)}{The difference of the top 10 largest eigenvalues to the corresponding reference eigenvalues from
             arallel Analysis (PA). @seealso \link[EFAfactors]{PA}}
}
}
\examples{
library(LSTMfactors)
set.seed(123)

##Take the data.DAPCS dataset as an example.
data(data.DAPCS)

response <- as.matrix(data.DAPCS[, 3:22]) ## loading data

\donttest{
## Run extractor.feature function
features <- extractor.feature(response)

print(features)
}




}
\seealso{
\link[LSTMfactors]{LSTM}
}
\author{
Haijiang Qin <Haijiang133@outlook.com>
}
