% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Go_vote.R
\docType{data}
\name{Go_vote}
\alias{Go_vote}
\title{Get out the vote experiment}
\format{
A data frame with 305866 rows and 6 variables:
\itemize{
\item sex of the voter (female or male)
\item yearofbirth: year of birth of the voter
\item primary2004: whether the voter voted in the 2004 primary election (voted, abstained)
\item messages: Get-out-the-vote message the voter received (Civic Duty, Control, Neighbors, Hawthorne)
\item primary2006: whether the voter turned out in the 2006 primary election (voted, abstained)
\item hhsize: household size of the voter
}
}
\usage{
data(Go_vote)
}
\description{
An experiment about ways to encourage voting in primary elections. During the 2006
primary election in Michigan, registered voters were randomly assigned to different
treatments, each in the form of a postcard mailed to them before the primary. The most high-pressure
message("Neighbors")
listed the voters neighbors and whether they voted in the previous primary elections. The card promised to
send out the same information after the 2006 primary, so that "you and your neighbors will all know who voted
and who did not." (From the Gerber et al. reference, below.) In another treatment, "Civic Duty," the postcard said, "On August 8,
remember your rights and responsibilities as a citizen. Remember to vote. DO YOUR CIVIC DUTY---VOTE!" Yet another
treatment, "Hawthorne" simply told the voter that "YOU ARE BEING STUDIED!" as part of research on why people do or do not vote. There
was also a control group that did not receive a postcard.
}
\references{
\itemize{
\item Imai, Kosuke. 2017. Quantitative Social Science: An Introduction. Princeton University Press. URL.
\item Alan S. Gerber, Donald P. Green, and Christopher W. Larimer (2008) “Social pressure and voter turnout: Evidence from a large-scale field experiment.” American Political Science Review, vol. 102, no. 1, pp. 33–48. doi: 10.1017/S000305540808009X
}
}
\keyword{datasets}
