% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProfitParticipation_Functions.R
\name{ProfitParticipationFunctions}
\alias{ProfitParticipationFunctions}
\alias{PP.base.NULL}
\alias{PP.base.PreviousZillmerReserve}
\alias{PP.base.ZillmerReserveT2}
\alias{PP.base.contractualReserve}
\alias{PP.base.previousContractualReserve}
\alias{PP.base.meanContractualReserve}
\alias{PP.base.ZillmerRiskPremium}
\alias{PP.base.sumInsured}
\alias{PP.base.totalProfitAssignment}
\alias{PP.rate.interestProfit}
\alias{PP.rate.riskProfit}
\alias{PP.rate.expenseProfit}
\alias{PP.rate.sumProfit}
\alias{PP.rate.terminalBonus}
\alias{PP.rate.terminalBonusFund}
\alias{PP.rate.interestProfitPlusGuarantee}
\alias{PP.rate.interestProfit2PlusGuarantee}
\alias{PP.rate.totalInterest}
\alias{PP.rate.totalInterest2}
\alias{PP.rate.interestProfit2}
\alias{getTerminalBonusReserve}
\alias{PP.calculate.RateOnBase}
\alias{PP.calculate.RateOnBaseMin0}
\alias{PP.calculate.RatePlusGuaranteeOnBase}
\alias{PP.calculate.RateOnBaseSGFFactor}
\alias{sumProfits}
\alias{PP.benefit.ProfitPlusTerminalBonusReserve}
\alias{PP.benefit.Profit}
\alias{PP.benefit.ProfitPlusGuaranteedInterest}
\alias{PP.benefit.ProfitPlusTotalInterest}
\alias{PP.benefit.ProfitPlusHalfTotalInterest}
\alias{PP.benefit.ProfitPlusHalfGuaranteedInterest}
\alias{PP.benefit.ProfitPlusInterestMinGuaranteeTotal}
\alias{PP.benefit.ProfitPlusHalfInterestMinGuaranteeTotal}
\alias{PP.benefit.ProfitGuaranteeSupporting}
\alias{PP.benefit.TerminalBonus5YearsProRata}
\alias{PP.benefit.TerminalBonus5Years}
\alias{PP.benefit.TerminalBonus}
\alias{PP.benefit.None}
\title{Helper functions for profit participation}
\usage{
PP.base.NULL(rates, params, values, ...)

PP.base.PreviousZillmerReserve(rates, params, values, ...)

PP.base.ZillmerReserveT2(rates, params, values, ...)

PP.base.contractualReserve(rates, params, values, ...)

PP.base.previousContractualReserve(rates, params, values, ...)

PP.base.meanContractualReserve(rates, params, values, ...)

PP.base.ZillmerRiskPremium(rates, params, values, ...)

PP.base.sumInsured(rates, params, values, ...)

PP.base.totalProfitAssignment(res, ...)

PP.rate.interestProfit(rates, ...)

PP.rate.riskProfit(rates, ...)

PP.rate.expenseProfit(rates, ...)

PP.rate.sumProfit(rates, ...)

PP.rate.terminalBonus(rates, ...)

PP.rate.terminalBonusFund(rates, ...)

PP.rate.interestProfitPlusGuarantee(rates, ...)

PP.rate.interestProfit2PlusGuarantee(rates, ...)

PP.rate.totalInterest(rates, ...)

PP.rate.totalInterest2(rates, ...)

PP.rate.interestProfit2(rates, ...)

getTerminalBonusReserve(
  profits,
  rates,
  terminalBonus,
  terminalBonusAccount,
  params,
  values,
  ...
)

PP.calculate.RateOnBase(base, rate, waiting, rates, params, values, ...)

PP.calculate.RateOnBaseMin0(base, rate, waiting, rates, params, values, ...)

PP.calculate.RatePlusGuaranteeOnBase(
  base,
  rate,
  waiting,
  rates,
  params,
  values,
  ...
)

PP.calculate.RateOnBaseSGFFactor(
  base,
  rate,
  waiting,
  rates,
  params,
  values,
  ...
)

sumProfits(profits, cols)

PP.benefit.ProfitPlusTerminalBonusReserve(profits, ...)

PP.benefit.Profit(profits, ...)

PP.benefit.ProfitPlusGuaranteedInterest(profits, rates, ...)

PP.benefit.ProfitPlusTotalInterest(profits, rates, params, values)

PP.benefit.ProfitPlusHalfTotalInterest(profits, ...)

PP.benefit.ProfitPlusHalfGuaranteedInterest(profits, rates, ...)

PP.benefit.ProfitPlusInterestMinGuaranteeTotal(profits, rates, ...)

PP.benefit.ProfitPlusHalfInterestMinGuaranteeTotal(profits, rates, ...)

PP.benefit.ProfitGuaranteeSupporting(profits, rates, params, values, ...)

PP.benefit.TerminalBonus5YearsProRata(profits, params, ...)

PP.benefit.TerminalBonus5Years(profits, params, ...)

PP.benefit.TerminalBonus(profits, params, ...)

PP.benefit.None(profits, ...)
}
\arguments{
\item{rates}{data.frame of profit rates}

\item{params}{Contract-specific, full set of parameters of the contract
(merged parameters of the defaults, the tariff, the profit participation
scheme and the contract)}

\item{values}{Contract values calculated so far (guaranteed component of the
insurance contract, including cash flows, premiums, reserves etc.).}

\item{...}{Other values that might be used for the calculation (currently unused)}

\item{res}{the data.frame of reserves.}

\item{profits}{The array of profit participation component values}

\item{terminalBonus}{The terminal bonus calculated}

\item{terminalBonusAccount}{The terminal bonus account (like a bank account,
where terminal bonuses are accrued, potentiall discounted from the maturity)}

\item{base}{The profit calculation base, on which the rate is to be applied}

\item{rate}{The profit participation rate}

\item{waiting}{A possible waiting period}

\item{cols}{The columns of the profit values array to be summed (columns given that do not exist in the profits array are ignired)}
}
\description{
Various helper functions for the \code{ProfitParticipation} class that
provide the building blocks for the individual components of profit participation,
the rates and how the assigned profit is calculated.
}
\section{Functions}{
\itemize{
\item \code{PP.base.NULL()}: Basis for profit: NONE (i.e. always returns 0)

\item \code{PP.base.PreviousZillmerReserve()}: Basis for profit: Previous Zillmer reserve (no administration cost reserve)

\item \code{PP.base.ZillmerReserveT2()}: Basis for profit: Zillmer reserve (no administration cost reserve) at time t-2

\item \code{PP.base.contractualReserve()}: Basis for profit: Contractual reserve (including administration costs) at time t

\item \code{PP.base.previousContractualReserve()}: Basis for profit: Contractual reserve (including administration costs) at time t-1

\item \code{PP.base.meanContractualReserve()}: Basis for profit: Contractual reserve (including administration costs) averaged over t and t-1

\item \code{PP.base.ZillmerRiskPremium()}: Basis for risk/mortality profit: Zillmer Risk Premium of the past year

\item \code{PP.base.sumInsured()}: Basis for expense/sum profit: sum insured

\item \code{PP.base.totalProfitAssignment()}: Basis for Terminal Bonus Fund Assignment: total profit assignment of the year

\item \code{PP.rate.interestProfit()}: Returns the array of interest profit rates (keyed by year)

\item \code{PP.rate.riskProfit()}: Returns the array of risk profit rates (keyed by year)

\item \code{PP.rate.expenseProfit()}: Returns the array of expense profit rates (keyed by year)

\item \code{PP.rate.sumProfit()}: Returns the array of sum profit rates (keyed by year)

\item \code{PP.rate.terminalBonus()}: Returns the array of terminal bonus rates (keyed by year)

\item \code{PP.rate.terminalBonusFund()}: Returns the array of terminal bonus rates (keyed by year) as the terminal bonus fund ratio

\item \code{PP.rate.interestProfitPlusGuarantee()}: Rate for interest on past profits: total credited rate, but at least the guarantee

\item \code{PP.rate.interestProfit2PlusGuarantee()}: Rate for interest on past profits: total creditedrate2, but at least the guarantee

\item \code{PP.rate.totalInterest()}: Rate for interest on past profits: total interest rate

\item \code{PP.rate.totalInterest2()}: Rate for interest on past profits: second total interest rate

\item \code{PP.rate.interestProfit2()}: Rate for interest on past profits: second interest profit rate (not including guaranteed interest), keyed by year

\item \code{getTerminalBonusReserve()}: Calculate the terminal bonus reserve.

\item \code{PP.calculate.RateOnBase()}: Calculate profit by a simple rate applied on the basis (with an optional waiting vector of values 0 or 1)

\item \code{PP.calculate.RateOnBaseMin0()}: Calculate profit by a simple rate applied on the basis (with an optional waiting vector of values 0 or 1), bound below by 0

\item \code{PP.calculate.RatePlusGuaranteeOnBase()}: Calculate profit by a rate + guaranteed interest applied on the basis (with an optional waiting vector of values 0 or 1)

\item \code{PP.calculate.RateOnBaseSGFFactor()}: Calculate profit by a simple rate applied on the basis (with only (1-SGFFactor) put into profit participation, and an optional waiting vector of values 0 or 1)

\item \code{sumProfits()}: Extract the given columns of the profit participation array of values and sum
them up. Columns that do not exist, because the profit scheme does not
provide the corresponding profit component will be silently ignored.
This allows generic benefit calculation functions to be written that do
not need to distinguish e.g. whether an old-style terminal bonus or a terminal
bonus fund is provided.

This function is not meant to be called directly, but within a profit benefit
calculation function.

\item \code{PP.benefit.ProfitPlusTerminalBonusReserve()}: Calculate survival benefit as total profit amount plus the terminal bonus reserve

\item \code{PP.benefit.Profit()}: Calculate benefit as total profit accrued so far

\item \code{PP.benefit.ProfitPlusGuaranteedInterest()}: Calculate accrued death benefit as total profit with (guaranteed) interest for one year

\item \code{PP.benefit.ProfitPlusTotalInterest()}: Calculate accrued death benefit as total profit with total interest (interest on profit rate) for one year

\item \code{PP.benefit.ProfitPlusHalfTotalInterest()}: Calculate accrued benefit as total profit with total interest (interest on profit rate) for half a year

\item \code{PP.benefit.ProfitPlusHalfGuaranteedInterest()}: Calculate death benefit as total profit with (guaranteed) interest for one year

\item \code{PP.benefit.ProfitPlusInterestMinGuaranteeTotal()}: Calculate accrued benefit as total profit with interest for one year (max of guarantee and total interest)

\item \code{PP.benefit.ProfitPlusHalfInterestMinGuaranteeTotal()}: Calculate accrued benefit as total profit with interest for half a year (max of guarantee and total interest)

\item \code{PP.benefit.ProfitGuaranteeSupporting()}: Calculate accrued benefit as regular profit, but used to cover initial Zillmerization

\item \code{PP.benefit.TerminalBonus5YearsProRata()}: Calculate benefit from terminal bonus as 1/n parts of the terminal bonus reserve during the last 5 years

\item \code{PP.benefit.TerminalBonus5Years()}: Terminal bonus is only paid out during the last 5 years of the contract (but never during the first 10 years)

\item \code{PP.benefit.TerminalBonus()}: Calculate benefit from terminal bonus (full bonus), either old-style terminal bonus reserve or Terminal Bonus Fund (TBF)

\item \code{PP.benefit.None()}: No benefit paid out

}}
