% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_Lifemap.R
\name{build_Lifemap}
\alias{build_Lifemap}
\title{A function to construct a LifemapR object, usable by the other functions of the package.}
\usage{
build_Lifemap(df, basemap = NULL, verbose = TRUE)
}
\arguments{
\item{df}{A dataframe containing at least one column named "taxid" that contains NCBI Taxonomy Identifiers (taxid).
The dataframe can contain any number of additional columns defining traits/characters/values associated to
each taxid.}

\item{basemap}{Deprecated argument.}

\item{verbose}{If TRUE (the default), the function will print detailed information to the console.
If FALSE, it will run silently.}
}
\value{
A list of class lifemap_obj containing:
\itemize{
\item df : a dataframe containing at least for each taxid :
\itemize{
\item The x coordinate (lon)
\item The y coordonate (lat)
\item The scientific name (sci_name)
\item The zoom level at which the taxa is visible (zoom)
\item A list of its ascendants (ascend)
\item Its type ("requested" or "ancestor")
\item Its direct ancestor
\item Its type (type), i.e. whether the taxid was
requested by the user ("requested") or if it is the anecestor of a requested taxid ("ancestor")
}
\item basemap : the basemap used to get taxa's details
}
}
\description{
A function to construct a LifemapR object, usable by the other functions of the package.
}
\examples{
data(eukaryotes_80)
\dontrun{
# make sure you have a good internet connection to load these very large files
LM <- build_Lifemap(eukaryotes_80)
}
}
