% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Decomp_sullivan.R
\name{Decomp_sullivan}
\alias{Decomp_sullivan}
\title{Two-dimensional decomposition of the difference between the two cohort HE by age and cause}
\usage{
Decomp_sullivan(attribution1, attribution2)
}
\arguments{
\item{attribution1}{A list returned by \code{Attribution_sullivan()}, representing Population 1.}

\item{attribution2}{A list returned by \code{Attribution_sullivan()}, representing Population 2.}
}
\value{
A list including matrices of mortality effects, disability effects, and total effects,
        as well as cohort HE and LE for each population.
}
\description{
This function implements the two-dimensional stepwise replacement decomposition algorithm (Andreev et al., 2002)
to quantify age-cause-specific effect of mortality and disability to the difference in cohort
health expectancy between two populations, based on longitudinal attribution results.
}
\examples{
data(attributionA)
data(attributionB)
summary(attributionA)
summary(attributionB)
decom_results <- Decomp_sullivan(attribution1=attributionA,attribution2=attributionA)
summary(decom_results)


}
