% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_weights.R
\name{summarize_weights}
\alias{summarize_weights}
\title{Summarize the Distribution of Weight Values}
\arguments{
\item{ipds_wts}{A data frame containing individual patient data from the
intervention study, with a column containing the estimated weights (derived
using \code{\link{estimate_weights}}).}

\item{intervention.arm}{The name of the grouping column in the data frame
specified by \emph{ipds}, e.g., intervention.arm = TRT. The default is TRT.}

\item{wt.col}{The name of the estimated weights column in the data frame
specified by \emph{ipds_wts}. The default is wt.}

\item{rswt.col}{The name of the estimated rescaled weights column in the
data frame specified by \emph{ipds_wts}. The default is wt_rs.}

\item{digits}{Specify the number of decimal places for the output results.}
}
\value{
A data frame containing a summary table of weights and rescaled
weights.
}
\description{
Summarize the Distribution of Weight Values
}
\examples{
\donttest{
summarize_weights(ipds_wts = pts, intervention.arm = TRT)
}

}
