% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-DataPreprocessing.R
\name{add_cohort_index}
\alias{add_cohort_index}
\title{Add cohort column to data frame}
\usage{
add_cohort_index(data, age_index, period_index, cohort_name = "cohort_index")
}
\arguments{
\item{data}{Data frame with age and period columns.}

\item{age_index}{Age index column in \code{data}.}

\item{period_index}{Period index column in \code{data}.}

\item{cohort_name}{Name of the cohort index column to be created. Defaults to \code{"cohort_index"}.}
}
\value{
Data frame with additional column for cohort indices.
}
\description{
Adds a column for cohort indices to a data frame, derived from specified age and period index columns through the relationship \code{cohort index = period index - age index + max(age index)}.
}
\keyword{internal}
