% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_drug_AE_pairs.R
\name{report_drug_AE_pairs}
\alias{report_drug_AE_pairs}
\title{Report the potential adverse events for drugs from contingency table}
\usage{
report_drug_AE_pairs(
  contin_table,
  contin_table_signal,
  along_rows = "AE",
  along_cols = "Drug"
)
}
\arguments{
\item{contin_table}{A data matrix of an \eqn{I} x \eqn{J} contingency
table with row (adverse event) and column (drug or vaccine) names.
Please first check the input contingency table using the function
\code{check_and_fix_contin_table()}.}

\item{contin_table_signal}{A data matrix with the same dimension and row
and column names as \code{contin_table}, with entries either 1
(indicating signal) or 0 (indicating non-signal). This data matrix can
be obtained via applying the function \code{mddc_boxplot} or
\code{mddc_mc}.}

\item{along_rows}{Specifies the content along the rows of the
\code{contin_table} (e.g. AE or Drug).}

\item{along_cols}{Specifies the content along the columns of the
\code{contin_table} (e.g. AE or Drug).}
}
\value{
A data frame with five variables:
\itemize{
\item \code{drug} the drug name.
\item \code{AE} the potential adverse event for the drug or vaccine.
\item \code{observed_num} the observed count of the (drug or vaccine, AE)
pair.
\item \code{expected_num} the expected count of the (drug or vaccine , AE)
pair.
\item \code{std_pearson_res} the value of the standardized Pearson residual.
}
}
\description{
Report the potential adverse events for drugs from contingency table
}
\examples{
# load statin49 data
data(statin49)

# run mddc boxplot method
test1 <- mddc_boxplot(statin49)

# get the signals from step 2
contin_table_signal <- test1$boxplot_signal

# get the signals from step 5
contin_table_signal_corr <- test1$corr_signal_pval < 0.05

# identify the (drug, AE) signals for step 2
result_1 <- report_drug_AE_pairs(
  contin_table = statin49,
  contin_table_signal = contin_table_signal
)
result_1

# identify the (drug, AE) signals for step 5
result_2 <- report_drug_AE_pairs(
  contin_table = statin49,
  contin_table_signal = contin_table_signal_corr
)
result_2
}
