% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MEA_heatmap.R
\name{MEA_heatmap}
\alias{MEA_heatmap}
\title{MEA_heatmap}
\usage{
MEA_heatmap(
  data,
  x_axis_title = "Experimental Condition",
  well_filter = "A1|A2|A3|A4|A5|A6|B1|B2|B3|B4|B5|B6|C1|C2|C3|C4|C5|C6|D1|D2|D3|D4|D5|D6"
)
}
\arguments{
\item{data}{Dataset containing well average synchrony index data.}

\item{x_axis_title}{Include title for heatmap x axis. Default is "Experimental Condition"}

\item{well_filter}{Argument can be used to filter for specific MEA wells to include in the heatmap.}
}
\value{
A heatmap of the synchrony index for each well grouped by heatmap condition.
}
\description{
Function creates a heatmap of the synchrony index for each well grouped by heatmap condition.
}
\examples{
p <- MEA_heatmap(data = input_heatmap_data,
            x_axis_title = "Experimental Condition",
            well_filter = "A1|A2|A3|A4|A5|A6|B1|B2|B3|B4|B5|B6|C1|C2|C3|C4|C5|C6|D1|D2|D3|D4|D5|D6")
}
