% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariateExpansions.R
\name{expandBasisFunction}
\alias{expandBasisFunction}
\title{Calculate a linear combination of arbitrary basis function}
\usage{
expandBasisFunction(scores, argvals = functions@argvals, functions)
}
\arguments{
\item{scores}{A matrix of dimension \code{N x K}, representing the \code{K} 
scores (coefficients) for each of the \code{N} observations.}

\item{argvals}{A list representing the domain, see \code{\link[funData]{funData}}
for details. Defaults to \code{functions@argvals}.}

\item{functions}{A \code{funData} object, representing \code{K} basis 
functions on a domain with arbitrary dimension.}
}
\value{
An object of class \code{funData} with \code{N} observations on 
  \code{argvals}, corresponding to the linear combination of the basis 
  functions.
}
\description{
This function calculates a linear combination of arbitrary basis functions on 
domains with arbitrary dimension.
}
\seealso{
\code{\link{univExpansion}}
}
\keyword{internal}
