#'Method of Moments Estimation of Logarithmic distribution
#'@description function to get the method of moment estimate(s) of logarithmic distribution
#'@param data A numeric vector.
#'@param plot logical which controls whether the barplot of the data along with the probability curve of the theoretical poisson distribution with the estimated parameters.
#'@param curvecol color of the theoretical probability curve
#'@param ... additional plotting parameters
#'@importFrom stats uniroot
#'@importFrom actuar dlogarithmic
#'@importFrom graphics hist curve
#'@return the estimated parameters by the method of moments of the data assuming the underlying distribution is logarithmic distribution
#'@examples
#'require(actuar)
#'logarithmic_est(rlogarithmic(1000,prob=0.6))
#'@export
logarithmic_est=function(data,plot=TRUE,curvecol="red",...)
{
  avg=mean(data)
  prob=uniroot(function(x) {return(avg+(x/((1-x)*log(exp(1),(1-x)))))},c(0,1))$root
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dlogarithmic(x,prob=prob),from=0,to=floor(max(data)),n=floor(max(data))+1,add=TRUE,col=curvecol)
  }
  output=list(prob)
  names(output)=c("prob")
  return(output)
}
