#' MSU palettes and MSU color variables
#'
#' This file contains only MSU palettes and MSU colour variables.
#'
#' @export
MSUpalettes <- list(
  msu_seq = list(
    c(
      "#18453b", "#2f574e", "#466a62",
      "#5d7c75", "#748f89", "#8ba29d",
      "#a2b4b0", "#b9c7c4", "#d0d9d7",
      "#e7eceb"
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
    "seq"
  ),
  msu_seq_red = list(
    c(
      "#280d01", "#511d06", "#792f0e",
      "#a24319", "#cb5a28", "#d5764c",
      "#df9573", "#eab69e", "#f4d9cd"
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    "seq"
  ),
  msu_seq_purple = list(
    c(
      "#150012", "#2c0025", "#420038",
      "#58004b", "#6e005f", "#8b1b7b",
      "#a7439a", "#c476ba", "#e2b4db"
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    "seq"
  ),
  msu_seq_yellow = list(
    c(
      "#313608", "#51590f", "#798418",
      "#a5b326", "#d1de3f", "#d5e051",
      "#dce365", "#e3ed84", "#f2f6c8"
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    "seq"
  ),
  msu_seq_blue = list(
    c(
      "#282b42", "#3d4263", "#5e668f",
      "#7980a3", "#909ab7", "#a5aabf",
      "#b3b7c9", "#c2c6d4", "#d5d8e3"
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    "seq"
  ),
  msu_seq_orange = list(
    c(
      "#4b2704", "#6e3b0b", "#945110",
      "#bd6a15", "#f08521", "#f2ac62",
      "#f5c487", "#f7d8ad", "#ffe3bf"
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    "seq"
  ),
  msu_seq_green = list(
    c(
      "#00230d", "#02461c", "#046a2b",
      "#088d3a", "#0db14b", "#31c067",
      "#5cd088", "#8cdfac", "#c3efd3"
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    "seq"
  ),
  msu_div = list(
    c(
      "#e41b12", "#eb5751", "#f29490",
      "#f9d1cf", "#d4d4d4", "#ccebf3",
      "#88d0e3", "#43b6d3", "#009cc4"
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9),
    "div"
  ),
  msu_core = list(
    c(
      "#18453b", "#ffffff", "#000000"  ## msu green, white, black
    ),
    c(1, 2, 3),
    "core"
  ),
  msu_qual1 = list(
    c(
      "#18453b",                                         ## msu green
      "#0db14b", "#97a2a2", "#f08521", "#008183",  ## kelly green, grey, orange, teal
      "#909ab7", "#535054", "#d1de3f", "#e8d9b5",  ## blue-grey, dark grey, yellow-green, cream
      "#c89a58", "#94ae4a", "#6e005f", "#cb5a28"   ## texas-brown, split pea soup green, eggplant, sienna
    ),
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13),
    "qual"
  ),
  msu_qual2 = list(
    c(
      "#18453b", "#f08521", "#6e005f", "#97a2a2"
    ),
    c(1, 2, 3, 4),
    "qual"
  )
)

#' MSU Spartan Green hex colour
#' @export
msu_green <- msu_Green <- msu_SpartanGreen <- "#18453b"

#' MSU white hex colour
#' @export
msu_white <- "#ffffff"

#' MSU black hex colour
#' @export
msu_black <- "#000000"

#' MSU Kelly Green hex colour
#' @export
msu_Kelly <- "#008208"

#' MSU Lime Green hex colour
#' @export
msu_Lime <- "#7bbd00"

#' MSU Excellence Green hex colour
#' @export
msu_Excellence <- "#0b9a6d"

#' MSU Refresh Green hex colour
#' @export
msu_Refresh <- "#008934"

#' MSU grey/gray hex colour
#' @export
msu_grey <- msu_gray <- "#97a2a2"

#' MSU orange hex colour
#' @export
msu_orange <- "#f08521"

#' MSU teal hex colour
#' @export
msu_teal <- "#008183"

#' MSU blue (aka blue-grey or blue-gray) hex colour
#' @export
msu_blue <- msu_bluegrey <- msu_bluegray <- "#909ab7"

#' MSU dark grey hex colour
#' @export
msu_darkgrey <- msu_darkgray <- "#535054"

#' MSU yellow (aka yellow-green or grellow) hex colour
#' @export
msu_yellow <- msu_greenyellow <- msu_yellowgreen <- msu_grellow <- "#d1de3f"

#' MSU peach hex colour
#' @export
msu_peach <- "#e8d9b5"

#' MSU (burnt) orange hex colour
#' @export
msu_orange <- msu_burnt <- "#c89a58"

#' MSU split pea hex colour
#' @export
msu_splitpea <- "#94ae4a"

#' MSU purple hex colour
#' @export
msu_purple <- "#6e005f"

#' MSU red hex colour
#' @export
msu_red <- "#cb5a28"
