% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pPerm.R
\name{pPerm}
\alias{pPerm}
\title{Calculate permutation p-value
Calculate perutation p-value of actual model performance vs null hypothesis distribution.
`pPerm` will calculate the cumulative (1-tailed) probability of `actual` belonging to `permutation_distribution`.
`side` is guessed by actual value compared to median(permutation_distribution).
Test is performed on original data OR ranked for non-parametric statistics.}
\usage{
pPerm(
  actual,
  permutation_distribution,
  side = c("smaller", "greater"),
  type = "t",
  extend = 0.1
)
}
\arguments{
\item{actual}{Actual model performance (e.g. misclassifications or Q2)}

\item{permutation_distribution}{Null hypothesis distribution from permutation test (same metric as `actual`)}

\item{side}{Smaller or greater than (automatically guessed if omitted) (Q2 and AUC is a "greater than" test, whereas misclassifications is "smaller than")}

\item{type}{one of ('t','non',"smooth","ecdf","rank")}

\item{extend}{extend how much it extend}
}
\value{
p-value
}
\description{
Calculate permutation p-value
Calculate perutation p-value of actual model performance vs null hypothesis distribution.
`pPerm` will calculate the cumulative (1-tailed) probability of `actual` belonging to `permutation_distribution`.
`side` is guessed by actual value compared to median(permutation_distribution).
Test is performed on original data OR ranked for non-parametric statistics.
}
\examples{
data("freelive2")
actual <- sample(YR2, 1)
permutation_distribution <- YR2
pPerm(actual, permutation_distribution)
}
