% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVAL.R
\name{plotVAL}
\alias{plotVAL}
\title{Plot validation metric}
\usage{
plotVAL(MUVRclassObject, show_outlier = TRUE)
}
\arguments{
\item{MUVRclassObject}{An object of class `MUVR`}

\item{show_outlier}{Boolean, show outliers}
}
\value{
A plot
}
\description{
Produces a plot of validation metric vs number of variables in model (inner segment).
}
\examples{
\donttest{
data("freelive2")
nRep <- 2
nOuter <- 4
varRatio <-0.6
regrModel <- MUVR2(X = XRVIP2,
                   Y = YR2,
                   nRep = nRep,
                  nOuter = nOuter,
                   varRatio = varRatio,
                   method = "PLS",
                   modReturn = TRUE)
plotVAL(regrModel)
}
}
