% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcess.R
\name{preProcess}
\alias{preProcess}
\title{Perform matrix pre-processing}
\usage{
preProcess(
  X,
  offset = 0,
  zeroOffset = 0,
  trans = "none",
  center = "none",
  scale = "none"
)
}
\arguments{
\item{X}{Data matrix with samples in rows and variables in columns}

\item{offset}{Add offset to all data points (defaults to 0)}

\item{zeroOffset}{Add offset to zero data (defaults to 0)}

\item{trans}{Either 'log', 'sqrt' or 'none' (default is 'none')}

\item{center}{Either 'mean', 'none' or a numeric vector of length equal to the number of columns of X (defaults to 'none').}

\item{scale}{Either 'UV', 'Pareto', 'none' or a numeric vector of length equal to the number of columns of X (defaults to 'none').}
}
\value{
A pre-processed data matrix
}
\description{
Perform matrix pre-processing
}
\examples{
data("freelive2")
preProcess(XRVIP2)
}
