% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{setKey}
\alias{setKey}
\title{Step1: Set model's API key and url.}
\usage{
setKey(api_key, model, api_url = NULL, ...)
}
\arguments{
\item{api_key}{A character string: the user's OpenAI/huggingface/gemini/claude/baichuan/other API key. Please fill 'NA' for self-deployed models.}

\item{model}{A character string: specify the model version. For gemini, you could input "gemini-pro"}

\item{api_url}{A character string: the API URL for the model. If not specified, the default Chat completion URL will be used based on the api_key.}

\item{...}{Additional arguments to be passed (currently not used, but kept for future extensibility).}
}
\value{
Prints a message to the console indicating whether the API key setup was successful.
If the setup fails, the function stops with an error message.
}
\description{
This function allows users to set and verify an API key for data collection. You can change the default api_url for others models' API.
}
\examples{
\dontrun{
set_key(api_key="YOUR_API_KEY", model="gpt-3.5-turbo", api_url="api.openai.com/v1/chat/completions")
}
}
