% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_loading.R
\name{load_epc_data_corrected}
\alias{load_epc_data_corrected}
\title{Load and Clean EPC Data}
\usage{
load_epc_data_corrected(file_path = "epc_data_new_ar5_indicators.csv")
}
\arguments{
\item{file_path}{Path to the EPC data CSV file}
}
\value{
Cleaned EPC data frame
}
\description{
Load and Clean EPC Data
}
\examples{
# Load sample EPC data from package
sample_file <- system.file("extdata", "sample_epc_data.csv", package = "ManyIVsNets")
if (file.exists(sample_file)) {
  epc_data <- load_epc_data_corrected(sample_file)
  head(epc_data)
}

\donttest{
# Example with external file (only runs if file exists)
if (file.exists("your_epc_data.csv")) {
  epc_data <- load_epc_data_corrected("your_epc_data.csv")
}
}
}
