% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulation_mc}
\alias{simulation_mc}
\title{Monte Carlo Simulation}
\usage{
simulation_mc(
  y,
  statistic,
  dgp = function(y) sample(y, replace = TRUE),
  N = 99,
  ...
)
}
\arguments{
\item{y}{A vector or data frame.}

\item{statistic}{A function or a character string that specifies
how the statistic is computed. The function needs to input the
\code{y} and output a scalar.}

\item{dgp}{A function. The function inputs the first argument
\code{y} and outputs a simulated \code{y}. It should represent the
data generating process under the null. Default value is the function
\code{sample(y, replace = TRUE)}, i.e. the
bootstrap resampling of \code{y}.}

\item{N}{An atomic vector. Number of replications of the test
statistic.}

\item{...}{Other named arguments for statistic which are
passed unchanged each time it is called}
}
\value{
The vector of replication of test statistic.
}
\description{
Generates N Monte Carlo replicates of a statistic.
}
\keyword{internal}
