% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-mts.R
\name{mts_check}
\alias{mts_check}
\title{Check \emph{mts} object for validity}
\usage{
mts_check(mts)
}
\arguments{
\item{mts}{\emph{mts} object.}
}
\value{
Returns \code{TRUE} invisibly if the \emph{mts} object is valid.
}
\description{
Checks on the validity of an \emph{mts} object. If any test
fails, this function will stop with a warning message.
}
\examples{
library(MazamaTimeSeries)

sts_check(example_mts)

# This would throw an error
if ( FALSE ) {

  broken_mts <- example_mts
  names(broken_mts) <- c('meta', 'bop')
  sts_check(broken_mts)

}

}
\seealso{
\link{mts_isValid}
}
