% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Melanoma_df}
\alias{Melanoma_df}
\title{Survival from Malignant Melanoma}
\format{
A data frame with 205 observations and 7 variables:
\describe{
  \item{time}{An integer representing the survival time of the patients (in months).}
  \item{status}{An integer indicating the status of the patient at the end of the study;
  typically coded as 1 for dead and 0 for alive.}
  \item{sex}{An integer representing the sex of the patient; usually coded as 1 for male
  and 0 for female.}
  \item{age}{An integer indicating the age of the patient at diagnosis (in years).}
  \item{year}{An integer representing the year of diagnosis.}
  \item{thickness}{A numeric value indicating the thickness of the melanoma (in millimeters).}
  \item{ulcer}{An integer indicating the presence of ulceration; usually coded as 1 for yes
  and 0 for no.}
}
}
\source{
Data collected from clinical studies on malignant melanoma.
}
\usage{
data(Melanoma_df)
}
\description{
The dataset name has been changed to 'Melanoma_df' to avoid confusion with other datasets from
packages in the R ecosystem and to follow the naming conventions of the 'MedDataSets' package.
The suffix '_df' indicates that this dataset is a data frame, helping to distinguish it from
other datasets within the package and from those in the broader R ecosystem. The original content
of the dataset has not been modified in any way.
}
\details{
This dataset contains information on survival rates of patients diagnosed with malignant melanoma,
including various clinical factors that may affect prognosis.
}
