% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ratliver_df}
\alias{ratliver_df}
\title{Drug Concentration in Rat Livers}
\format{
A data frame with 19 observations and 4 variables:
\describe{
  \item{BodyWt}{Integer variable indicating body weight of the rat (in grams)}
  \item{LiverWt}{Numeric variable representing the weight of the liver (in grams)}
  \item{Dose}{Numeric variable representing the total dose administered (in mg)}
  \item{DoseInLiver}{Numeric variable representing the percentage of the dose found in the liver}
}
}
\source{
Data taken from the isdals package version 3.0.1
}
\usage{
data(ratliver_df)
}
\description{
This dataset, ratliver_df, is a data frame containing results from an experiment
investigating drug absorption in the livers of rats. Nineteen rats were weighed,
given an oral dose of approximately 40 mg of drug per kilogram of body weight,
and sacrificed after a fixed period. Liver weight and the percentage of the administered
dose found in the liver were recorded.
}
\details{
The dataset name has been kept as 'ratliver_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
