% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ATC_code_tbl_df}
\alias{ATC_code_tbl_df}
\title{Drug Related ATC Codes}
\format{
A tibble with 50 observations and 10 variables:
\describe{
  \item{atc_code}{Character variable representing the ATC code assigned to the drug}
  \item{level_1}{Character variable indicating the anatomical main group}
  \item{code_1}{Character variable indicating the code of level 1}
  \item{level_2}{Character variable indicating the therapeutic subgroup}
  \item{code_2}{Character variable indicating the code of level 2}
  \item{level_3}{Character variable indicating the pharmacological subgroup}
  \item{code_3}{Character variable indicating the code of level 3}
  \item{level_4}{Character variable indicating the chemical subgroup}
  \item{code_4}{Character variable indicating the code of level 4}
  \item{drugbank-id}{Character variable with the corresponding DrugBank identifier}
}
}
\source{
Data taken from the package covid19dbcand version 0.1.1
}
\usage{
data(ATC_code_tbl_df)
}
\description{
This dataset, ATC_code_tbl_df, is a tibble containing ATC (Anatomical Therapeutic Chemical)
classification codes assigned to drugs by the World Health Organization. The classification
system categorizes drugs into different levels of anatomical and chemical structure.
}
\details{
The dataset name has been kept as 'ATC_code_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
