% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_lme.R
\name{predict.graph_lme}
\alias{predict.graph_lme}
\title{Prediction for a mixed effects regression model on a metric graph}
\usage{
\method{predict}{graph_lme}(
  object,
  newdata = NULL,
  mesh = FALSE,
  mesh_h = 0.01,
  which_repl = NULL,
  compute_variances = FALSE,
  compute_pred_variances = FALSE,
  posterior_samples = FALSE,
  pred_samples = FALSE,
  n_samples = 100,
  edge_number = "edge_number",
  distance_on_edge = "distance_on_edge",
  normalized = FALSE,
  no_nugget = FALSE,
  return_as_list = FALSE,
  return_original_order = TRUE,
  check_euclidean = TRUE,
  advanced_options = list(),
  ...,
  data = deprecated()
)
}
\arguments{
\item{object}{The fitted object with the \code{graph_lme()} function.}

\item{newdata}{A \code{data.frame} or a \code{list} containing the covariates, the edge
number and the distance on edge for the locations to obtain the prediction. Observe that you should not provide the locations for each replicate. Only a single set of locations and covariates, and the predictions for the different replicates will be obtained for this same set of locations.}

\item{mesh}{Obtain predictions for mesh nodes? The graph must have a mesh and should not have covariates.}

\item{mesh_h}{If the graph does not have a mesh, one will be created with this
value of 'h'.}

\item{which_repl}{Which replicates to obtain the prediction. If \code{NULL} predictions
will be obtained for all replicates. Default is \code{NULL}.}

\item{compute_variances}{Set to TRUE to compute the kriging variances.}

\item{compute_pred_variances}{Set to TRUE to compute the prediction variances. Will only be computed if newdata is \code{NULL}.}

\item{posterior_samples}{If \code{TRUE}, posterior samples for the random effect will be returned.}

\item{pred_samples}{If \code{TRUE}, prediction samples for the response variable will be returned. Will only be computed if newdata is \code{NULL}.}

\item{n_samples}{Number of samples to be returned. Will only be used if
\code{sampling} is \code{TRUE}.}

\item{edge_number}{Name of the variable that contains the edge number, the
default is \code{edge_number}.}

\item{distance_on_edge}{Name of the variable that contains the distance on
edge, the default is \code{distance_on_edge}.}

\item{normalized}{Are the distances on edges normalized?}

\item{no_nugget}{Should the prediction be carried out without the nugget?}

\item{return_as_list}{Should the means of the predictions and the posterior
samples be returned as a list, with each replicate being an element?}

\item{return_original_order}{Should the results be return in the original
(input) order or in the order inside the graph?}

\item{check_euclidean}{Check if the graph used to compute the resistance distance has Euclidean edges? The graph used to compute the resistance distance has the observation locations as vertices.}

\item{advanced_options}{Advanced options for internal use only. This parameter is intended to be used by the cross-validation function and should not be used otherwise.}

\item{...}{Not used.}

\item{data}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{newdata} instead.}
}
\value{
A list with elements \code{mean}, which contains the means of the
predictions, \code{fe_mean}, which is the prediction for the fixed effects, \code{re_mean}, which is the prediction for the random effects, \code{variance} (if \code{compute_variance} is \code{TRUE}), which contains the
posterior variances of the random effects, \code{samples} (if \code{posterior_samples} is \code{TRUE}),
which contains the posterior samples.
}
\description{
Prediction for a mixed effects regression model on a metric graph
}
