% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.codes.R
\name{Reg.MESR}
\alias{Reg.MESR}
\title{Fit Mixed-Effects Spline Regression Models with GAM for Microbial Features on Group-Level}
\usage{
Reg.MESR(
  Data_for_Reg,
  pre_processed_data,
  unique_values = 5,
  z_score = NA,
  Knots = NULL,
  max_Knots = 3,
  seed = 123
)
}
\arguments{
\item{Data_for_Reg}{The data frame output from the \code{\link[MicrobTiSDA]{Design}}.}

\item{pre_processed_data}{The transformed data output from the \code{\link[MicrobTiSDA]{Data.trans}} function. A
pre-processed OTU data frame with sample IDs as row names and OTU IDs as column names.}

\item{unique_values}{An integer specifying the minimum number of unique values required in an OTU for spline fitting (default: 5).}

\item{z_score}{A numeric value specifying the z-score threshold for outlier filtering; if \code{NA}, no
outlier filtering is performed (default: \code{NA}).}

\item{Knots}{An optional numeric vector specifying the knots to use in the spline regression. If \code{NULL}, the optimal number of
knots is determined by minimizing the GCV criterion (default: \code{NULL}).}

\item{max_Knots}{An integer indicating the maximum number of knots to consider when selecting the optimal spline model (default: 3).}

\item{seed}{Random seed.}
}
\value{
An object of class \code{RegMESR} with two elements: \code{fitted_model} is a nested list containing the fitted mixed-effects GAM models for each design
dummy variable and OTU; \code{knots_info_each_model} is a corresponding nested list with the knots used for each model.
}
\description{
This function fits mixed-effect spline regression models using GAM to capture nonlinear temporal trends in microbial
community data at the group level. It incorporates random effects for individual IDs within each group and uses
natural splines to model the relationship between time and microbial feature abundances.
}
\details{
This function fits mixed-effects spline regression models. Unlike \code{\link[MicrobTiSDA]{Reg.SPLR}}, this function
captures the overall temporal dynamics of microbial features across different groups. Assuming the dataset contains
\eqn{\textit{m}} groups, each with \eqn{\textit{n}} subjects, the model is formulated as:
\deqn{x_{(mi)}(t) = \beta_{m0} + \sum_{k=1}^{K} \beta_{mk} \cdot N_{mk}(t) + b_{n(m)} + \epsilon}
where \eqn{x_{(mi)}(t)} represents the abundance of microbial feature \eqn{\textit{i}} at time point \eqn{\textit{t}}
in group \eqn{\textit{m}}. The random effect \eqn{b_{n(m)}} reflects the departure of individual \eqn{\textit{n}} in group
\eqn{\textit{m}} from overall population average effects. The parameter \eqn{K} refers to the number of basis functions,
which is equal to the number of knots plus one. (i.e., \eqn{K = number of knots + 1}).

The \code{Reg.MESR} function first extracts independent variables from a design matrix (produced by the \code{\link[MicrobTiSDA]{Design}})
by removing columns corresponding to the pre-processed OTU data. For each design dummy variable (excluding the first
and last columns), the function subsets the data to include only the observations where the dummy variable equals 1.
Then, for each OTU in the pre-processed data, it optionally filters out outliers based on a specified z-score threshold.
If the number of unique transformed OTU values exceeds a given threshold (\code{unique_values}), a mixed-effects spline
regression model is fitted using a natural spline on the time variable along with a random effect for the sample ID.
When the \code{Knots} parameter is not provided, the function iterates over a range of knot numbers (from 1
to \code{max_Knots}), selects the optimal model by minimizing the Generalized Cross-Validation (GCV) criterion,
and extracts the corresponding knot locations. Alternatively, if \code{Knots} is provided, it is directly used in
model fitting. The resulting fitted models and associated knots information are organized into nested lists and returned.
}
\examples{
\donttest{
metadata <- data.frame(
  TimePoint = c(1, 2, 3, 4),
  Sample = c('S1', 'S2', 'S3', 'S4'),
  GroupA = c('A', 'A', 'B', 'B'),
  GroupB = c('X', 'Y', 'X', 'Y')
)

# Example pre-processed data (e.g., transformed abundance data)
Pre_processed_Data <- data.frame(
  Feature1 = rnorm(4),
  Feature2 = rnorm(4)
)

# Create design matrix using grouping variables
design_data <- Design(metadata, Group_var = c('GroupA', 'GroupB'), Pre_processed_Data,
                      Sample_Time = 'TimePoint', Sample_ID = 'Sample')

fit_result <- Reg.MESR(Data_for_Reg = design_data,
                       pre_processed_data = Pre_processed_Data,
                       unique_values = 5,
                       z_score = 2,
                       Knots = NULL,
                       max_Knots = 5)
}
}
\author{
Shijia Li
}
