% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acide.R
\name{Ops.acid}
\alias{Ops.acid}
\title{Operators on the Acid Class}
\usage{
\method{Ops}{acid}(e1, e2)
}
\arguments{
\item{e1}{acid-object, numeric or MicrobialGrowth-object.}

\item{e2}{acid-object or numeric.}
}
\value{
a new acid or MicrobialGrowth-object.
}
\description{
Operators for the "\link{Acid}" class.
}
\details{
Operations between an acid and a numeric are the most common case.
In this case, the operation is carried out on the \code{concentration} member of the acid.
A new acid-object is returned with the new concentration.

Operations between acids are tolerated (but not recommended).
To do this, the two acids must have the same \code{alpha} sensitivity and the same \code{MIC},
and the operation is carried out between the concentrations of the two acids.
A new acid-object is returned with the new concentration.

The addition operator \code{+} can be used between MicrobialGrowth-object (left side) and an acid-object (right side).
This operation symbolizes the application of the acid to the MicrobialGrowth-object.
A new MicrobialGrowth-object is returned with its coefficients (and confidence intervals) modified by the acid.
}
\examples{
# Acids and numerics
print( Acid(1.245, 5.47) * 5 )
## acid {alpha=1.245, MIC=5.47g/L, concentration=5g/L}

print( Acid(1.245, 5.47) / 3 )
## acid {alpha=1.245, MIC=5.47g/L, concentration=0.333333333333333g/L}

print( 3 / Acid(1.245, 5.47) )
## acid {alpha=1.245, MIC=5.47g/L, concentration=3g/L}

print( 3 / Acid(1.245, 5.47, 0.5) )
## acid {alpha=1.245, MIC=5.47g/L, concentration=6g/L}

# Acids and acids
print( Acid(1.245, 5.47, 0.5) + Acid(1.245, 5.47, 2) )
## acid {alpha=1.245, MIC=5.47g/L, concentration=2.5g/L}

try({
  print( Acid(1.245, 5.47, 0.5) + Acid(1, 5.47, 2) )
  ## throws an error since `alpha` and/or `MIC` are not equal
})

# Acids and MicrobialGrowth-object
g <- MicrobialGrowth.create(N0 = c(0.13, 0.15), Nmax = 1.43, mu = c(0.05, 0.07, 0.09),
lambda = c(45, 49, 43), xlim = c(0, 100), model="gompertz")
aceticAcid <- Acid(1.245, 5.47)
{
  cat("Before :\n")
  print(g)
  cat("After:\n")
  print(g + aceticAcid)
}
## Before :
## MicrobialGrowth, model gompertz:
##     N0   Nmax     mu lambda
##   0.14   1.43   0.07  45.00
## After:
## MicrobialGrowth, model gompertz:
##          N0        Nmax          mu      lambda
##  0.14000000  1.43000000  0.06156075 51.16896670

# Also works with the `acid.specific.pair` subclass
print( Acid.SpecificPair(list(c(0.98, 5.68), c(1.51, 5.26))) )
## acid {{alpha=0.98, MIC=5.68g/L},
##       {alpha=1.51, MIC=5.26g/L}, concentration=6g/L}
}
