% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mysource.R
\name{MLFA}
\alias{MLFA}
\title{Estimates a Mixture of Longitudinal Factor Analyzers (MLFA) model}
\usage{
MLFA(C, d, X, Y, Z, id, max_it, fixed_factor = 1:d, seed = 1, scale = TRUE)
}
\arguments{
\item{C}{an integer giving the number of mixture components.}

\item{d}{an integer giving the number of latent factors in the factor analysis model.}

\item{X}{a matrix containing the design matrix for fixed effects covariates for the mixed effect model explaining the latent factors (an unit column can be included to estimate an intercept).}

\item{Y}{a matrix containing the observed outcomes / indicators of interest for the factor model.}

\item{Z}{a matrix containing the design matrix for random effects covariates for the mixed effect model explaining the latent factors.}

\item{id}{a vector containing subject identifiers.}

\item{max_it}{an integer giving the maximum number of iterations for the expectation-maximization algorithm for parameter estimation. The algorithm might stop before \eqn{max_it} if the mean absolute difference between two successive iterations is smaller than \eqn{10^(-5)}}

\item{fixed_factor}{a vector of integers of length d containing the columns in Y with factor loadings fixed to 1.}

\item{seed}{a seed value for the random initialization of parameters.}

\item{scale}{an optional Boolean indicating whether the matrix Y needs to be scaled or not.}
}
\value{
a list with the following components:
\describe{
  \item{Lam}{a list of length \eqn{C} containing the estimated factor loading matrix for each cluster.}
  \item{beta}{a list of length \eqn{C} containing the estimated fixed effect coefficients numeric vector of length p*d where p is the number of fixed effect and d is the number of latent factors. The function fixed_coef can be used to extract the fixed effect coefficient for a given cluster and for a given latent factor.}
  \item{S_b}{a list of length \eqn{C} containing the estimated covariance matrices of the random effects.}
  \item{S_e}{a list of length \eqn{C} containing the estimated covariance matrices of the error term in the mixed effect model (both intra and inter-factor covariances).}
  \item{tau}{a list of length \eqn{C} containing the vector of estimated variances of the error terms \eqn{\epsilon_{itjc}} in the factor 'measurement' model.}
  \item{pro}{a numeric vector containing the estimated proportion of each cluster.}
  \item{BIC}{a numeric value of the Bayesian Information Criterion for model selection for either the number of clusters or the number of latent factors.}
  \item{AIC}{a numeric value of the Akaike Information Criterion for model selection.}
  \item{ICL}{a numeric value of the Integrated Completed Likelihood for model selection.}
  \item{ri}{a matrix containig the the probability of class membership for each subject.}
  \item{VerifNan}{a Boolean indicating whether the model generated Nan values or not.}
}
}
\description{
This function performs a mixture of longitudinal factor analyzers on multivariate longitudinal data as described by Ounajim et al (2023). The MLFA model is written a two equations representing a measurement factor model describing the link between the outcomes / indicators of interest \eqn{Y} and one or several latent factors \eqn{eta}, and a structural mixed effect model describing the link between the latent factors and a set of explanatory variables in the design matrices \eqn{X} and \eqn{Z} for fixed and random effects respectively:
\deqn{y_{itj}=\sum_{c=1}^{C}\mathbb{1}_{\{v_{i}=c\}}\left(\Lambda_{jc} \eta_{i.tc}+\epsilon_{itjc}\right),}
\deqn{\eta_{iktc} = X_{iktc}\beta_{kc} +  Z_{iktc}b_{ikc} + e_{itc},}
where i is the subject index, t is the measurement time index, j is the outcome index and k is latent factor index. The model parameters are estimated using the Expectation-Maximization (EM) algorithm.
}
\examples{
# Load the necessary datasets
data(simulated_MLFA)  # Load a simulated dataset based on the MLFA model
# Extract matrices from the list
# Extract matrix Y of outcomes of interest for the factor analysis model
Y <- simulated_MLFA$Y
# Extract matrix X of fixed effect covariates for describing the latent factors
X <- simulated_MLFA$X
# Extract matrix Z of random effect covariates for describing the latent factors
Z <- simulated_MLFA$Z
# Extract matrix id containing subject identifiers.
id <-simulated_MLFA$id
#' # Run the MLFA (Mixture of Longitudinal Factor Analyzers) function with:
# C: number of classes or clusters in our simulated data was set to 2.
# d: number of latent factors in our simulated data was set to 1.
# max_it: maximum number of iterations is set to 50 for a quick test.
# Estimation of the parameters of the MLFA model using the simulated data.
result_MLFA <- MLFA(C = 2, d = 2, X, Y, Z, id, max_it = 50, fixed_factor =  c(1,6))
# Print the resulting factor loading matrices and fixed effect coefficients
print(result_MLFA$Lam)
print(result_MLFA$beta)
}
\references{
Ounajim, A., Slaoui, Y., Louis, P. Y., Billot, M., Frasca, D., & Rigoard, P. (2023). Mixture of longitudinal factor analyzers and their application to the assessment of chronic pain.
Statistics in medicine, 42(18), 3259–3282. https://doi.org/10.1002/sim.9804
}
