% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inbreeding.exp.R
\name{inbreeding.exp}
\alias{inbreeding.exp}
\title{Expected inbreeding}
\usage{
inbreeding.exp(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  depth.pedigree = 7,
  start.kinship = NULL,
  elements = NULL,
  storage.save = 1.5,
  verbose = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{depth.pedigree}{Depth of the pedigree in generations}

\item{start.kinship}{Relationship matrix of the individuals in the first considered generation}

\item{elements}{Vector of individuals from the database to include in pedigree matrix}

\item{storage.save}{Lower numbers will lead to less memory but slightly higher computing time (default: 1.5, min: 1)}

\item{verbose}{Set to FALSE to not display any prints}
}
\value{
Pedigree-based inbreeding in gen/database/cohort selected individuals
}
\description{
Function to derive pedigree based inbreeding
}
\examples{
data(ex_pop)
inbreeding <- inbreeding.exp(population=ex_pop, gen=5)
}
