% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{r.data.frame}
\alias{r.data.frame}
\title{Data frame initialization for forward sampling}
\usage{
r.data.frame(bn, dag)
}
\arguments{
\item{bn}{A list of lists obtained from the function \link{MoTBFs_Learning}.}

\item{dag}{An object of class \code{"bn"}, representing the graph of the bayesian network.}
}
\value{
An object of class \code{"data.frame"}, which contains the data type of each column and has no rows.
}
\description{
The function \code{r.data.frame()} initializes a data frame with as many columns as nodes in the MoTBF-network. It also asings each column its data type, i.e., numeric or character. In the case of character columns, the states of the variable are extracted from the \code{"bn"} argument and included as levels.
}
\examples{

## Create a dataset
  # Continuous variables
  x <- rnorm(100)
  y <- rnorm(100)
  
  # Discrete variable
  z <- sample(letters[1:2],size = 100, replace = TRUE)
  
  data <- data.frame(C1 = x, C2 = y, D1 = z, stringsAsFactors = FALSE)
  
## Get DAG
  dag <- LearningHC(data)
  
## Learn a BN
  bn <- MoTBFs_Learning(dag, data, POTENTIAL_TYPE = "MTE")
  
## Initialize a data.frame containing 3 columns (x, y and z) with their attributes.
  r.data.frame(bn, dag)
}
