% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultLSD.R
\name{MultLSD}
\alias{MultLSD}
\title{Multiple Least-Squares Difference tests (MultLSD)}
\usage{
MultLSD(formula, design, responses, tested.term)
}
\arguments{
\item{formula}{A formula with no left term that specify the model from the elements of the \strong{design} argument.}

\item{design}{A data.frame that contains only factors specifying the design on which rely the specified model of \strong{formula} argument.}

\item{responses}{A matrix or data.frame that contains only numerics or integers being the responses variables to be explained by the model from \strong{formula}.}

\item{tested.term}{A character specifying the term from \strong{formula} for which the MultLSD tests must be performed.}
}
\value{
A symmetric matrix having as rows and columns as there is levels of the \strong{tested.term} and that contains the pairwise fdr corrected p-values of the MultLSD tests.
}
\description{
Performs the Multiple Least-Squares Difference tests of a term from the model defined by \strong{formula} as defined in Mahieu & Cariou (2025).
}
\examples{
data(OTU)
lsd=MultLSD(~Lot+Atm+Time,OTU[,1:4],OTU[,-c(1:4)],"Time")
print(lsd)
}
\references{
Mahieu, B., & Cariou, V. (2025). MultANOVA Followed by Post Hoc Analyses for Designed High‐Dimensional Data: A Comprehensive Framework That Outperforms ASCA, rMANOVA, and VASCA. Journal of Chemometrics, 39(7). \doi{https://doi.org/10.1002/cem.70039}
}
