% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Approximations.r
\name{Edgeworth}
\alias{Edgeworth}
\title{Edgeworth expansion of a multivariate density}
\usage{
Edgeworth(X, cum, n = 1)
}
\arguments{
\item{X}{A matrix of d-variate data}

\item{cum}{a list containing the raw (unstandardized) cumulant vectors of X. At least the
first 3 cumulants need to be provided.}

\item{n}{the number of terms in the mean \eqn{\bar{\mathbf{X}}}}
}
\value{
The vector of the Edgeworth density evaluated at X
}
\description{
Provides the truncated Edgeworth approximation to a multivariate density of
\eqn{W = \sqrt{n} \bar{X}}
Approximation can use up to the first k=8 cumulants. The function implements the formula
\deqn{f_{\mathbf{W}^{\left( n\right) }}\left( \mathbf{w}\right)  =\left(
1+\sum_{k=1}^{\infty }\frac{n^{-k/2}}{k!}\mathbf{B}_{k}\left( \frac{%
   \boldsymbol{\kappa }_{\mathbf{Y},3}^{\otimes \intercal }\mathbf{H}_{3}\left(
     \mathbf{z}|\mathbf{I}\right) }{6},\ldots ,\frac{
       \boldsymbol{\kappa }_{\mathbf{Y},k+2}^{\otimes }\mathbf{H}_{k+2}\left(
         \mathbf{z}|\mathbf{I}\right) }{\left( k+1\right) \left( k+2\right) }\right)
 \right) \varphi \left( \mathbf{w}|\boldsymbol{\Sigma }_{\mathbf{X}}\right)}
where \eqn{\mathbf{z}=\boldsymbol{\Sigma }_{\mathbf{X}}^{-1/2}(\mathbf{X}-\boldsymbol{\mu}_{\mathbf{X}})},
\eqn{\mathbf{B}_{k}} denote the T-Bell Polynomials and \eqn{\varphi} denotes the
multivariate normal density. The case \eqn{n=1} provides and approximation
to the density of \eqn{\mathbf{X}} and can be compared to the \code{GramCharlier} approximation.
}
\examples{
# Edgeworth density approximation (k=4) of data generated from
# a bivariate skew-gaussian distribution
n<-500
alpha<-c(10,0)
omega<-diag(2)
X<-rSkewNorm(n,omega,alpha)
EC<-SampleMomCum(X,r=4,centering=FALSE,scaling=FALSE)
EC<-EC$estCum.r  ## (estimated) raw cumulants of X
fx4<-Edgeworth(X[1:50,],cum=EC,n=1)

}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021. Section 4.7.
}
\seealso{
Other Approximations: 
\code{\link{GramCharlier}()},
\code{\link{IntEdgeworth}()},
\code{\link{IntGramCharlier}()},
\code{\link{MTCE}()}
}
\concept{Approximations}
