% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Approximations.r
\name{GramCharlier}
\alias{GramCharlier}
\title{Gram-Charlier approximation to a multivariate density}
\usage{
GramCharlier(X, cum)
}
\arguments{
\item{X}{A matrix of d-variate data}

\item{cum}{a list containing the raw (unstandardized) cumulant vectors of X. At least the
first 3 cumulants need to be provided}
}
\value{
The vector of the Gram-Charlier density evaluated at X
}
\description{
Provides the truncated Gram-Charlier approximation to a multivariate density. Approximation can
be up to the first k=8 cumulants according to the formula
\deqn{f_{\mathbf{X}}\left( \mathbf{x}\right) =\left(
 1+\sum_{k=3}^{\infty }\frac{1}{k!}\mathbf{B}_{k}^{\intercal }\left( 0,0,
 \boldsymbol{\kappa }_{\mathbf{Y},3}^{\otimes },\ldots \boldsymbol{\kappa }_{
 \mathbf{Y},k}^{\otimes }\right) \mathbf{H}_{k}\left( \mathbf{y}|\mathbf{I}
 \right) \right) \varphi \left( \mathbf{x}|\boldsymbol{\mu},\boldsymbol{\Sigma }_{
\mathbf{X}}\right),  }
where the Hermite polynomial \eqn{\mathbf{H}_{k}\left( \mathbf{y}| \mathbf{I}\right)
=\mathbf{H}_{k}\left( \boldsymbol{\Sigma }^{-1/2}\mathbf{x} \right) } corresponds to the \emph{standard} Gaussian variate,
the cumulants are the cumulants of the standardized variate \eqn{\mathbf{Y}=
\boldsymbol{\Sigma }^{-1/2}\left( \mathbf{X}-\boldsymbol{\mu }\right) } of
\eqn{\mathbf{X}}, (\eqn{\boldsymbol{\mu }={E}\mathbf{X}}) and \eqn{\varphi \left(
 \mathbf{x}\boldsymbol{|\boldsymbol{\mu},\Sigma }\right)} denotes the multivariate normal
density function with mean \eqn{\boldsymbol{\mu}} and variance matrix \eqn{\boldsymbol{
 \Sigma }}.
}
\examples{
# Gram-Charlier density approximation (k=4) of data generated from
# a bivariate skew-gaussian distribution
n<-500
alpha<-c(10,0)
omega<-diag(2)
X<-rSkewNorm(n,omega,alpha)
EC<-SampleMomCum(X,r=4,centering=FALSE,scaling=FALSE)
EC<-EC$estCum.r  ## (estimated) raw cumulants of X
fx4<-GramCharlier(X[1:50,],cum=EC)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021. Section 4.7.
}
\seealso{
Other Approximations: 
\code{\link{Edgeworth}()},
\code{\link{IntEdgeworth}()},
\code{\link{IntGramCharlier}()},
\code{\link{MTCE}()}
}
\concept{Approximations}
