% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_OLS_methods.R
\name{print.NAVAE_CI_OLS}
\alias{print.NAVAE_CI_OLS}
\alias{as.data.frame.NAVAE_CI_OLS}
\title{Print and coerce a NAVAE_CI_OLS object}
\usage{
\method{print}{NAVAE_CI_OLS}(x, verbose = 0, ...)

\method{as.data.frame}{NAVAE_CI_OLS}(x, ...)
}
\arguments{
\item{x}{the object}

\item{verbose}{if zero, only basic printing is done. Higher values corresponds
to more detailed output.}

\item{...}{additional arguments, currently ignored.}
}
\value{
\code{print.Navae_ci_ols} prints information about \code{x} and returns it
invisibly.

\code{as.data.frame.NAVAE_CI_OLS} returns a data frame consisting
of two observations for each vector u given as a line of \code{matrix_u},
with the following columns:
\itemize{
   \item \code{name}: name of the estimateed coefficient in the linear model
   \item \code{lower}: lower bound of the confidence interval
   \item \code{upper}: upper bound of the confidence interval
   \item \code{estimate}: the estimated value of the coefficient
   \item \code{length}: the length of the interval

   \item \code{method}: the method used for the computation of the confidence
   intervals. This is either "Asymptotic (CLT-based), or "NAVAE (BE-based)",
   or "NAVAE (EE-based)".

   \item \code{regime}: the regime used for the computation of the CI
   (only applicable for NAVAE confidence intervals).
   Four regimes are possible: \itemize{
       \item the degenerate regimes \code{R1} and \code{R2} in which
       the confidence interval is \code{(-Inf, Inf)}.
       \item the exponential regime \code{Exp}
       \item the Edgeworth regime \code{Edg}.
   }
}
}
\description{
This also displays CLT-based confidence intervals. The results are different
from the confidence intervals that can be obtained via \code{confint(lm( ))}
since they are robust to heteroscedasticity.
}
\examples{
n = 4000
X1 = rnorm(n, sd = 1)
true_eps = rnorm(n)
Y = 8 * X1 + true_eps
X = cbind(X1)

myCI <- Navae_ci_ols(Y, X, K_xi = 3, intercept = TRUE, a = 1.1)

print(myCI)
as.data.frame(myCI)


}
\references{
Derumigny, A., Girard, L., & Guyonvarch, Y. (2025).
Can we have it all?
Non-asymptotically valid and asymptotically exact confidence intervals
for expectations and linear regressions.
ArXiv preprint, \doi{10.48550/arXiv.2507.16776}
}
\seealso{
The function to generate such objects \code{\link{Navae_ci_ols}}.

The corresponding methods for the mean:
\code{\link{print.NAVAE_CI_Mean}} and
\code{\link{as.data.frame.NAVAE_CI_Mean}}.
}
