% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotope_conversions.R
\name{R_to_delta}
\alias{R_to_delta}
\title{Convert heavy-to-light isotope ratio to delta values.}
\usage{
R_to_delta(R_values, element)
}
\arguments{
\item{R_values}{A vector of isotope ratios (e.g., R values).}

\item{element}{Which element to return delta values -
carbon, oxygen, or hydrogen.}
}
\value{
Vector of isotope ratios in delta notation.
}
\description{
Converts a heavy-to-light stable isotope ratio to
a corresponding delta value, in per mil values.
}
\examples{
R_to_delta(R_values = 2005.20e-6, element = 'oxygen') # returns 0.
}
\author{
Rich Fiorella \email{rfiorella@lanl.gov}
}
