% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{cov_func}
\alias{cov_func}
\title{N-factor model covariance:}
\usage{
cov_func(parameters, dt)
}
\arguments{
\item{parameters}{a named vector of parameters of an N-factor model. Function \code{NFCP_parameters} is recommended.}

\item{dt}{a discrete time step}
}
\value{
A \code{matrix} object with dimensions \mjeqn{N \times N}{N X N}, where \eqn{N} is the number of factors of the specified N-factor model.
}
\description{
\loadmathjax
Calculate the covariance matrix of state variables for a given N-factor model parameters and discrete time step.
}
\details{
The primary purpose of the \code{model_covariance} function is to be called within other functions of the \code{NFCP} package. The covariance of an N-factor model is given by:


\mjdeqn{cov_{1,1}(x_{1,t},x_{1,t}) = \sigma_1^2t}{cov[1,1](x[1,t],x[1,t]) = sigma[1]^2 * t}
\mjdeqn{cov_{i,j}(x_{i,t},x_{j,t}) = \sigma_i\sigma_j\rho_{i,j}\frac{1-e^{-(\kappa_i+\kappa_j)t}}{\kappa_i+\kappa_j}}{cov[i,j](x[i,t],x[j,t]) = sigma[i] sigma[j] rho[i,j] (1-e^(-(kappa[i]+kappa[j])t ) / (kappa[i] + kappa[j])}
}
\examples{
#Calculate the covariance matrix of a two-factor model over one discrete (weekly) time step:
SS_oil.covariance <- cov_func(SS_oil$two_factor, SS_oil$dt)

}
\references{
Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.

Cortazar, G., and L. Naranjo, (2006). An N-factor Gaussian model of oil futures prices. \emph{Journal of Futures Markets: Futures, Options, and Other Derivative Products}, 26(3), 243-268.
}
\keyword{internal}
