% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{chmFieldAccessFunction}
\alias{chmFieldAccessFunction}
\title{Get Javascript function name for accessing a specific string field in each element of string vector.}
\usage{
chmFieldAccessFunction(fieldsep, idx)
}
\arguments{
\item{fieldsep}{The separator to be used for splitting the input string. This should be a single
character string.}

\item{idx}{The index (zero origin) of the field to be returned after splitting the input string.
This should be a single integer.}
}
\value{
The name of the newly created field access function.
}
\description{
This function returns the name of a Javascript function thats accepts a string vector
as its parameter, and for each string in the vector splits the string into fields separated by
fieldsep, and accesses field idx (zero origin).  The function returns a vector of these fields.
}
\details{
The name of the function returned for a specific fieldsep and idx will be
constant within an R session, but may differ between R sessions (or if this
library is unloaded and reloaded).
}
\examples{
# Create a new field access function that splits the input string at ',' and
# returns the first field.
chmFieldAccessFunction(',', 1)
# Create a new field access function that splits the input string at '-' and
# returns the second field.
chmFieldAccessFunction('-', 2)

}
\seealso{
\code{\link[=chmGetFunction]{chmGetFunction()}}

\code{\link[=chmStringopFunction]{chmStringopFunction()}}
}
