% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NGLVieweR.R
\name{setPosition}
\alias{setPosition}
\title{Set Position}
\usage{
setPosition(NGLVieweR, x = 0, y = 0, z = 0)
}
\arguments{
\item{NGLVieweR}{A NGLVieweR object.}

\item{x}{Position along the x-axis in angstroms. Default is 0.}

\item{y}{Position along the y-axis in angstroms. Default is 0.}

\item{z}{Position along the z-axis in angstroms. Default is 0.}
}
\value{
NGLVieweR object with updated setPosition parameters.
}
\description{
Set position for the representation
}
\examples{
NGLVieweR("7CID") \%>\%
stageParameters(backgroundColor = "white") \%>\%
addRepresentation("cartoon", param=list(name="cartoon", colorValue="red")) \%>\%
addRepresentation("ball+stick", param=list(name="ball+stick",
colorValue="yellow",
colorScheme="element",
sele="200")) \%>\%
setPosition(25, 0, 0)
}
\seealso{
\itemize{
\item \code{\link[=setScale]{setScale()}}
\item \code{\link[=zoomMove]{zoomMove()}}
\item \code{\link[=setRotation]{setRotation()}}
}

Other transformations: 
\code{\link{setRotation}()},
\code{\link{setScale}()},
\code{\link{zoomMove}()}
}
\concept{transformations}
