% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_pca_trajectories_general}
\alias{plot_pca_trajectories_general}
\title{Plot PCA Trajectories for Time Series Data}
\usage{
plot_pca_trajectories_general(
  pca_results,
  pc_x = "PC1",
  pc_y = "PC2",
  trajectory_grouping = NULL,
  timepoint_var = "Timepoint",
  timepoint_order = NULL,
  individual_var = "Experiment",
  point_size = 3,
  alpha = 0.7,
  line_size = 2,
  smooth_lines = FALSE,
  color_palette = NULL,
  save_plots = FALSE,
  output_dir = NULL,
  plot_prefix = "PCA_trajectories",
  width = 12,
  height = 8,
  dpi = 150,
  return_list = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{pca_results}{A data frame or list containing PCA results}

\item{pc_x}{Character string specifying the principal component for x-axis (default: "PC1")}

\item{pc_y}{Character string specifying the principal component for y-axis (default: "PC2")}

\item{trajectory_grouping}{Character vector of column names for grouping trajectories}

\item{timepoint_var}{Character string specifying the timepoint column (default: "Timepoint")}

\item{timepoint_order}{Character vector specifying the order of timepoints}

\item{individual_var}{Character string for individual trajectory identification (default: "Experiment")}

\item{point_size}{Numeric value controlling point size (default: 3)}

\item{alpha}{Numeric value controlling transparency (default: 0.7)}

\item{line_size}{Numeric value controlling line thickness (default: 2)}

\item{smooth_lines}{Logical indicating whether to apply smoothing (default: FALSE)}

\item{color_palette}{Character vector of colors for groups}

\item{save_plots}{Logical indicating whether to save plots (default: FALSE)}

\item{output_dir}{Character string specifying output directory (default: NULL)}

\item{plot_prefix}{Character string prefix for filenames (default: "PCA_trajectories")}

\item{width}{Numeric plot width in inches (default: 12)}

\item{height}{Numeric plot height in inches (default: 8)}

\item{dpi}{Numeric plot resolution (default: 150)}

\item{return_list}{Logical indicating whether to return results as list (default: TRUE)}

\item{verbose}{Logical indicating whether to print messages (default: TRUE)}
}
\value{
A list containing plots, trajectories, and metadata
}
\description{
This function creates comprehensive visualizations of PCA trajectories over time,
showing both individual and group-averaged trajectories with optional smoothing.
}
