% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world-functions.R
\name{clearPatches}
\alias{clearPatches}
\alias{clearPatches,worldMatrix-method}
\alias{clearPatches,worldArray-method}
\title{Clear \code{world}'s \code{patches}}
\usage{
clearPatches(world)

\S4method{clearPatches}{worldMatrix}(world)

\S4method{clearPatches}{worldArray}(world)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}
}
\value{
\code{WorldMatrix} object with \code{NA} values for all \code{patches}.
}
\description{
Reset all \code{patches} values to \code{NA}.
}
\examples{
w1 <- createWorld()
w1 <- NLset(world = w1, agents = patches(w1), val = runif(NLcount(patches(w1))))
w1Val <- of(world = w1, agents = patches(w1))
summary(w1Val)

w1 <- clearPatches(w1)
w1Val <- of(world = w1, agents = patches(w1))
summary(w1Val)

}
\references{
Wilensky, U. 1999. NetLogo. https://www.netlogo.org.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://docs.netlogo.org/dictionary.html#clear-patches}
}
\author{
Sarah Bauduin
}
