% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{randomYcor}
\alias{randomYcor}
\alias{randomYcor,worldNLR,numeric-method}
\title{Random \code{ycor}}
\usage{
randomYcor(world, n)

\S4method{randomYcor}{worldNLR,numeric}(world, n)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{n}{Integer.}
}
\value{
Numeric. Vector of length \code{n} of \code{ycor} coordinates.
}
\description{
Report \code{n} random \code{ycor} coordinates within the \code{world}'s extent.
}
\examples{
w1 <- createWorld(
  minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
  data = runif(25)
)
t1 <- createTurtles(n = 10, coords = cbind(
  xcor = randomXcor(world = w1, n = 10),
  ycor = randomYcor(world = w1, n = 10)
))
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)

}
\references{
Wilensky, U. 1999. NetLogo. https://www.netlogo.org.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://docs.netlogo.org/dictionary.html#random-cor}
}
\author{
Sarah Bauduin
}
