% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{turtles2sf}
\alias{turtles2sf}
\alias{turtles2sf,ANY-method}
\title{From \code{agentMatrix} to \code{sf}}
\usage{
turtles2sf(turtles)

\S4method{turtles2sf}{ANY}(turtles)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}
}
\value{
\code{sf} object of \verb{POINT geometry} representing the moving \code{agents}
(coordinates and data)
as contained in \code{turtles}.
}
\description{
Convert an \code{agentMatrix} object into an \code{sf} object.
}
\examples{
t1 <- createTurtles(n = 10, coords = cbind(xcor = 1:10, ycor = 1:10))
if (requireNamespace("sf", quietly = TRUE)) {
  sf_t1 <- turtles2sf(turtles = t1)
}

}
\author{
Sarah Bauduin
}
