% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/origin_helper.r
\name{origin-methods}
\alias{origin-methods}
\alias{print.origin}
\alias{summary.origin}
\alias{plot.origin}
\alias{performance.origin}
\title{methods for origin estimation objects of class \code{origin}}
\usage{
\method{print}{origin}(x, ...)

\method{summary}{origin}(object, x = object, ...)

\method{plot}{origin}(x, y = "id", start, ...)

\method{performance}{origin}(x, start, graph = NULL, ...)
}
\arguments{
\item{x}{object of class \code{\link{origin}}, origin estimation object from function \code{origin_xxx}}

\item{...}{further arguments to be passed to default \code{plot} function}

\item{object}{object of class \code{\link{origin}}, origin estimation object from function \code{origin_xxx}; passed to \code{x}}

\item{y}{character specifying the variable being plotted at the y-axis; options are \code{'id'} for node identifier (default), \code{'mdist'} for mean distance (only available for \code{\link{origin_edm}}) or \code{'wvar'} for weighted variance (only available for \code{\link{origin_edm}})}

\item{start}{numeric, giving the node of the true origin}

\item{graph}{\code{igraph} object specifying the underlying network graph with attribute 'length' on edges for calculation of distance to the correct origin}
}
\value{
\code{performance.origin} returns a \code{data.frame} with variables
  \itemize{
    \item \code{origin = start} representing the true origin, 
    \item \code{est} the estimated node of origin, 
    \item \code{hitt} logical indicating whether origin estimation is correct or not, 
    \item \code{rank} rank of correct detection, 
    \item \code{spj} number of segments from estimated origin to true origin (requires an \code{igraph} object), 
    \item \code{dist} distance along the shortest path from estimated origin to true origin (\code{igraph} edge attribute \code{length})
  }
}
\description{
\code{print} produces an output for objects of class \code{origin}.
}
\examples{
data(ptnGoe)
data(delayGoe)

res <- origin(events=delayGoe[10,-c(1:2)], type='centrality', graph=ptnGoe)
res

summary(res)
plot(res, start=1)
performance(res, start=1, graph=ptnGoe)

}
\seealso{
\code{\link{origin}} \code{\link{plot_performance}}
}
