% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCGenRayleigh.r
\name{HCGenRayleigh}
\alias{HCGenRayleigh}
\alias{dhc.gen.rayleigh}
\alias{phc.gen.rayleigh}
\alias{qhc.gen.rayleigh}
\alias{rhc.gen.rayleigh}
\alias{hhc.gen.rayleigh}
\title{Half-Cauchy Generalized Rayleigh Distribution}
\usage{
dhc.gen.rayleigh(x, alpha, lambda, theta, log = FALSE)
phc.gen.rayleigh(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qhc.gen.rayleigh(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rhc.gen.rayleigh(n, alpha, lambda, theta)
hhc.gen.rayleigh(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dhc.gen.rayleigh}: numeric vector of (log-)densities
  \item \code{phc.gen.rayleigh}: numeric vector of probabilities
  \item \code{qhc.gen.rayleigh}: numeric vector of quantiles
  \item \code{rhc.gen.rayleigh}: numeric vector of random variates
  \item \code{hhc.gen.rayleigh}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Half-Cauchy Generalized Rayleigh distribution.
}
\details{
The Half-Cauchy Generalized Rayleigh distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Half-Cauchy Generalized Rayleigh distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
\quad 1 - \frac{2}{\pi }\arctan \left\{ { - \frac{\alpha }{\theta }
\log \left \{ {1 - {e^{ - {{\left( {\lambda x} \right)}^2}}}} \right\}} \right\} \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dhc.gen.rayleigh()} — Density function
  \item \code{phc.gen.rayleigh()} — Distribution function
  \item \code{qhc.gen.rayleigh()} — Quantile function
  \item \code{rhc.gen.rayleigh()} — Random generation
  \item \code{hhc.gen.rayleigh()} — Hazard function
}
}
\examples{
x <- seq(1.0, 5, 0.25)
dhc.gen.rayleigh(x, 2.0, 0.5, 0.1)
phc.gen.rayleigh(x, 2.0, 0.5, 0.1)
qhc.gen.rayleigh(0.5, 2.0, 0.5, 0.1)
rhc.gen.rayleigh(10, 2.0, 0.5, 0.1)
hhc.gen.rayleigh(x, 2.0, 0.5, 0.1)

# Data
x <- stress66
# ML estimates
params = list(alpha=1.4585, lambda=0.5300, theta=0.1655)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = phc.gen.rayleigh, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qhc.gen.rayleigh, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dhc.gen.rayleigh, pfun=phc.gen.rayleigh, plot=FALSE)
print.gofic(out)

}
\references{
Sapkota, L.P., & Kumar, V. (2023). 
Half-Cauchy Generalized Rayleigh : Theory and Applications.\emph{South East Asian 
J. Math. & Math. Sc.}, \bold{19(1)}, 335--360. \doi{10.56827/SEAJMMS.2023.1901.27}

Shrestha, S.K., & Kumar, V. (2014). 
Bayesian Analysis for the Generalized Rayleigh Distribution. 
\emph{International Journal of Statistika and Mathematika}, \bold{9(3)}, 118--131.

Kundu, D., & Raqab, M.Z. (2005). 
Generalized Rayleigh Distribution: Different Methods of Estimation. 
\emph{Computational Statistics and Data Analysis}, \bold{49}, 187--200.
}
