\name{NeuDist-package}
\alias{NeuDist-package}
\alias{NeuDist}
\docType{package}
\title{
Univariate Continuous Distributions with Model Diagnostics
}
\description{
Tools for univariate continuous distributions with model diagnostics, based on the
 Lindley, Logistic, Half-Cauchy, Half-Logistic, and Poisson families, providing functions
 for probability density, distribution, quantile, and hazard evaluation, random variate 
 generation, and generic diagnostic tools such as Q–Q and P–P plots, goodness-of-fit tests, 
 and model selection criteria, with support for 58 distributions and 15 data sets.
}
\details{

\bold{Distributions in the 'NeuDist' package:}
\preformatted{
ChenExp                 Chen-Exponential Distribution.
ExpoExpPower            Exponentiated Exponential Power Distribution.  
ExpoInvChen             Exponentiated Inverse Chen Distribution. 
GompertzExt             Gompertz Extension Distribution. 
HCChen                  Half-Cauchy Chen Distribution. 
HCGenExp                Half-Cauchy Generalized Exponential Distribution. 
HCGenRayleigh           Half-Cauchy Generalized Rayleigh Distribution. 
HCGompertz              Half-Cauchy Gompertz Distribution. 
HCInvGPZ                Half-Cauchy Inverse Gompertz Distribution. 
HCInvNHE                Half-Cauchy Inverse NHE Distribution. 
HCNHE                   Half-Cauchy exponential extension Distribution. 
HLIW                    Half Logistic Inverted Weibull Distribution. 
HLNHE                   Half Logistic NHE Distribution.
InvEEP                  Inverse Exponentiated Exponential Poisson Distribution.  
InvExpPower             Inverse Exponential Power Distribution. 
InvGenGPZ               Inverse Generalized Gompertz Distribution. 
InvPham                 Inverse Pham Distribution. 
InvPowerCauchy          Inverse Power Cauchy Distribution.
InvSGZ                  Inverted Shifted Gompertz Distribution. 
InvUBD                  Inverse Upside Down Bathtub-Shaped Hazard Distribution. 
LindleyChen             Lindley-Chen Distribution. 
LindleyExpPower         Lindley Exponential Power Distribution. 
LindleyGenInvExp        Lindley Generalized Inverted Exponential Distribution. 
LindleyGompertz         Lindley Gompertz Distribution.
LindleyHC               New Lindley Half Cauchy Distribution. 
LindleyInvExp           Lindley Inverse Exponential Distribution. 
LindleyInvWeibull       Lindley inverse Weibull Distribution. 
LindleyRayleigh         New Lindley-Rayleigh Distribution. 
LogisChen               Logistic Chen Distribution Distribution. 
LogisExpExt             Logistic Exponential Extension Distribution. 
LogisExpPower           Logistic-Exponential Power Distribution. 
LogisGompertz           Logistic Gompertz Distribution.  
LogisInvExp             Logistic Inverse Exponential Distribution. 
LogisInvLomax           Logistic Inverse Lomax Distribution. 
LogisInvWeibull         Logistic Inverse Weibull Distribution. 
LogisLomax              Logistic Lomax Distribution. 
LogisModExp             Logistic-Modified Exponential Distribution.
LogisNHE                Logistic-NHE Distribution. 
LogisRayleigh           Logistic-Rayleigh Distribution.
LogisWeib               Logistic-Weibull Distribution. 
ModAtanExp              Modified Arctan Exponential Distribution. 
ModGE                   Modified Generalized Exponential Distribution. 
ModInvGE                Modified Inverse Generalized Exponential Distribution. 
ModInvLomax             Modified Inverse Lomax Distribution.
ModInvNHE               Modified Inverse NHE Distribution. 
ModUbd                  Modified Upside Down Bathtub Shaped Hazard Function 
NewLindleyHC            New Lindley Half Cauchy Distribution. 
Perks                   Perks Distribution. 
PoisInvWeib             Poisson Inverse Weibull Distribution. 
PoissonChen             Poisson Chen Distribution. 
PoissonExpPower         Poisson Exponential Power Distribution. 
PoissonGenRayleigh      Poisson Generalized Rayleigh Distribution.
PoissonGPZ              Poisson Gompertz Distribution. 
PoissonInvLomax         Poisson Inverted Lomax Distribution.
PoissonInvNHE           Poisson Inverse NHE Distribution.  
PoissonInvSGZ           Poisson Inverse Shifted Gompertz Distribution.  
PoissonNHE              Poisson NHE Distribution. 
PoissonSGZ              Poisson Shifted Gompertz Distribution.
}

\bold{General functions:}
\preformatted{
gofic              Generic Goodness-of-Fit(GoF) and Model Diagnostics Function 
pp.plot            Generic Probability-Probability(P–P) Plot Function  
qq.plot            Generic Quantile-Quantile(Q-Q) Plot Function
}

\bold{Data:}
\preformatted{
bladder            Bladder Cancer Recurrence Times
conductors         Electromigration Failure Times of Microcircuit Conductors
fibers63           Strength of 63 Carbon Fibers at 10 mm Gauge Length
fibers65           Strength of 65 Carbon Fibers at 50 mm Gauge Length
fibers69           Tensile Strength of 69 Carbon Fibers at 20 mm Gauge Length
headneck44         Head and Neck Cancer Survival Times
rainfall           March Rainfall in Minneapolis/St. Paul
reactorpump        Failure Time Intervals of Secondary Reactor Pumps
relief             Relief Times of Patients Receiving an Analgesic
stress             Breaking Stress of Carbon Fibres
stress31           Fatigue Life of 6061-T6 Aluminum Coupons under 31,000 psi
stress66           Breaking Stress of 66 Carbon Fibers of Length 50 mm
survtimes          Survival Times of Guinea Pigs Infected with Tubercle Bacilli
waiting            Waiting Times of 100 Bank Customers
windshield         Service Times of Aircraft Windshields
}
}
\author{
Vijay Kumar <vkgkp@rediffmail.com>,
    Laxmi Prasad Sapkota <laxmi75@gmail.com>,
    Pankaj Kumar <pankajagadish@gmail.com>,
    Lal Babu Sah <lalbabu3131@gmail.com>

Maintainer: Vijay Kumar <vkgkp@rediffmail.com>
}
