% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{bootstrap}
\alias{bootstrap}
\title{bootstrap}
\usage{
bootstrap(estimator, Z, B = 400, blocks = NULL, use_gpu = TRUE)
}
\arguments{
\item{estimator}{a neural point estimator}

\item{Z}{either a list of data sets simulated conditionally on the fitted parameters (parametric bootstrap); or a single observed data set containing independent replicates, which will be sampled with replacement \code{B} times (non-parametric bootstrap)}

\item{B}{number of non-parametric bootstrap samples}

\item{blocks}{integer vector specifying the blocks in non-parameteric bootstrap. For example, with 5 replicates, the first two corresponding to block 1 and the remaining three corresponding to block 2, \code{blocks} should be \code{c(1,1,2,2,2)}}

\item{use_gpu}{boolean indicating whether to use the GPU if it is available}
}
\value{
d × \code{B} matrix, where d is the dimension of the parameter vector
}
\description{
Compute bootstrap estimates from a neural point estimator
}
