% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{OASIS_long_tbl_df}
\alias{OASIS_long_tbl_df}
\title{Longitudinal MRI Data in Nondemented and Demented Older Adults}
\format{
A tibble with 373 observations and 15 variables:
\describe{
  \item{Subject ID}{Unique identifier for each subject (character)}
  \item{MRI ID}{Identifier for each MRI session (character)}
  \item{Group}{Clinical group classification (character)}
  \item{Visit}{Visit number for longitudinal assessment (numeric)}
  \item{MR Delay}{Time in days between MRI sessions (numeric)}
  \item{M/F}{Sex of the participant (character)}
  \item{Hand}{Handedness of the participant (character)}
  \item{Age}{Age in years at the time of the visit (numeric)}
  \item{EDUC}{Years of education (numeric)}
  \item{SES}{Socioeconomic status score (numeric)}
  \item{MMSE}{Mini-Mental State Examination score (numeric)}
  \item{CDR}{Clinical Dementia Rating score (numeric)}
  \item{eTIV}{Estimated total intracranial volume (numeric)}
  \item{nWBV}{Normalized whole-brain volume (numeric)}
  \item{ASF}{Atlas scaling factor (numeric)}
}
}
\source{
Data taken from Kaggle: \url{https://www.kaggle.com/datasets/jboysen/mri-and-alzheimers}
}
\usage{
data(OASIS_long_tbl_df)
}
\description{
This dataset, OASIS_long_tbl_df, is a tibble containing a longitudinal collection of MRI data
from 150 subjects aged 60 to 96, obtained as part of the Open Access Series of Imaging Studies (OASIS).
Each participant completed two or more MRI sessions, with visits spaced at least one year apart,
resulting in a total of 373 imaging sessions. The dataset includes both nondemented and demented older adults
and provides comprehensive demographic, clinical, and neuroimaging measures for each visit.
}
\details{
The dataset name has been kept as OASIS_long_tbl_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix tbl_df indicates that the dataset is a tibble (a modern data frame).
The original content has not been modified in any way. Variable names and values are provided exactly
as they appear in the source.
}
