% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoSleepR.R
\name{with_nosleep}
\alias{with_nosleep}
\title{Execute an expression while preventing the system from sleeping}
\usage{
with_nosleep(expr, keep_display = FALSE)
}
\arguments{
\item{expr}{Expression to execute while nosleep is on.}

\item{keep_display}{logical. If TRUE, also prevent the display from sleeping.}
}
\value{
The result of evaluating \code{expr}.
}
\description{
Helper that automatically brackets an expression with \code{nosleep_on()}
and \code{nosleep_off()}.
}
\examples{
\dontrun{
with_nosleep({
  message("Downloading a large file…")
  download_large_file()
})
}

}
