% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organic_carbon.R
\name{calc_organic_carbon}
\alias{calc_organic_carbon}
\title{Calculate amount of organic carbon}
\usage{
calc_organic_carbon(A_SOM_LOI, D_BDS, D_RD)
}
\arguments{
\item{A_SOM_LOI}{(numeric) The percentage organic matter in the soil}

\item{D_BDS}{(numeric) The bulk density of the soil}

\item{D_RD}{(numeric) The root depth of the crop}
}
\value{
The total amount of Carbon in the soil (kg C / ha). A numeric value.
}
\description{
This function calculates the amount of organic carbon in the soil
}
\examples{
calc_organic_carbon(A_SOM_LOI = 4.3, D_BDS = 1100, D_RD = 0.2)
calc_organic_carbon(A_SOM_LOI = c(1,4.3), D_BDS = c(1100,1300), D_RD = c(0.2,0.6))

}
