% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCR.R
\name{PCR}
\alias{PCR}
\title{Principal Component Regression (PCR)}
\usage{
PCR(data, threshold)
}
\arguments{
\item{data}{A data frame where the first column is the response variable and the remaining columns are predictor variables.}

\item{threshold}{The proportion of variance to retain in the principal components (default is 0.95).}
}
\value{
A list containing the following elements:
\item{Bhat}{The estimated regression coefficients, including the intercept.}
\item{RMSE}{The Root Mean Square Error of the regression model.}
\item{summary}{The summary of the linear regression model.}
\item{yhat}{The predicted values of the response variable.}
}
\description{
The \code{PCR} function performs Principal Component Regression (PCR) on a given dataset.
It standardizes the predictor variables, determines the number of principal components to retain based on a specified threshold,
and fits a linear regression model using the principal component scores.
}
\details{
The function performs the following steps:
1. Standardize the predictor variables.
2. Compute the covariance matrix of the standardized predictors.
3. Perform eigen decomposition on the covariance matrix to obtain principal components.
4. Determine the number of principal components to retain based on the cumulative explained variance exceeding the specified threshold.
5. Project the standardized predictors onto the retained principal components.
6. Fit a linear regression model using the principal component scores.
7. Back-transform the regression coefficients to the original scale.
}
\examples{
\dontrun{
# Example data
set.seed(1234)
n <- 2000
p <- 10
mu0 <- as.matrix(runif(p, 0))
sigma0 <- as.matrix(runif(p, 0, 10))
ro <- as.matrix(c(runif(round(p / 2), -1, -0.8), runif(p - round(p / 2), 0.8, 1)))
R0 <- ro \%*\% t(ro)
diag(R0) <- 1
Sigma0 <- sigma0 \%*\% t(sigma0) * R0
x <- mvrnorm(n, mu0, Sigma0)
colnames(x) <- paste("x", 1:p, sep = "")
e <- rnorm(n, 0, 1)
B <- sample(1:3, (p + 1), replace = TRUE)
en <- matrix(rep(1, n * 1), ncol = 1)
y <- cbind(en, x) \%*\% B + e
colnames(y) <- paste("y")
data <- data.frame(cbind(y, x))

# Call the PCR function
result <- PCR(data, threshold = 0.9)

# Access the estimated regression coefficients
print(Bhat <- result$Bhat)

# Access the predicted values
print(yhat <- result$yhat)

# Print the summary of the regression model
print(result$summary)

# Print the RMSE
print(paste("RMSE:", result$RMSE))
}

}
\seealso{
\code{\link{lm}}: For fitting linear models.

\code{\link{eigen}}: For computing eigenvalues and eigenvectors.
}
