% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ORFID_events.R
\name{import_ORFID_events}
\alias{import_ORFID_events}
\title{Import event records from Oregon RFID antenna readers}
\usage{
import_ORFID_events(file, delim, verbose = FALSE)
}
\arguments{
\item{file}{.txt file generated by an Oregon RFID reader.}

\item{delim}{field/column delimiter, which must be tab ('\\t'), comma (',') or semi-colon (';').}

\item{verbose}{If \emph{TRUE}, a description of the compiled data is printed to the console.}
}
\value{
Returns a tibble object.
}
\description{
Imports files from Oregon RFID (radio-frequency identification) ORMR (Oregon RFID Multi-Reader) and ORSR (Oregon RFID Single Reader) antenna readers. Only event records are retained during compilation (detections are removed). The function will not work with older generations of Oregon RFID antenna readers.

This function will only work with raw data downloaded directly from Oregon RFID stationary readers. The files must be delimited (tab, comma, or semicolon) and unedited by the user.
}
\details{
The field/column delimiter must be tab, comma or semi-colon for data compilation. The function cannot be used for space delimited data.
}
\examples{

# Importing event records from a single ORFID reader 
import_ORFID_events(file = system.file("extdata/orfid_data_file.txt", 
package = "ORFID"), delim = "\t")

}
\author{
Hugo Marques <biohmarques@gmail.com>
}
