% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentationHelper.R
\name{style-table}
\alias{style-table}
\title{Helper for consistent documentation of table arguments.}
\arguments{
\item{type}{Character string specifying the desired output table format. See
\code{visOmopResults::tableType()} for supported table types. If \code{type = NULL},
global options (set via \code{visOmopResults::setGlobalTableOptions()}) will be
used if available; otherwise, a default 'gt' table is created.}

\item{style}{Defines the visual formatting of the table. This argument can be
provided in one of the following ways:
\enumerate{
\item \strong{Pre-defined style}: Use the name of a built-in style (e.g., "darwin").
See \code{visOmopResults::tableStyle()} for available options.
\item \strong{YAML file path}: Provide the path to an existing .yml file defining
a new style.
\item \strong{List of custome R code}: Supply a block of custom R code or a named
list describing styles for each table section. This code must be specific to
the selected table type.
}

If \code{style = NULL}, the function will use global options
(see\code{visOmopResults::setGlobalTableOptions()}) or a _brand.yml file
(if found); otherwise, the default style is applied.}
}
\description{
Helper for consistent documentation of table arguments.
}
\keyword{internal}
